/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.CompositeOption;

public class OptionUtils {
    private OptionUtils() {
    }

    public static Option[] expand(Option ... options) {
        ArrayList<Option> expanded = new ArrayList<Option>();
        if (options != null) {
            for (Option option : options) {
                if (option == null) continue;
                if (option instanceof CompositeOption) {
                    expanded.addAll(Arrays.asList(((CompositeOption)option).getOptions()));
                    continue;
                }
                expanded.add(option);
            }
        }
        return expanded.toArray(new Option[expanded.size()]);
    }

    public static Option[] combine(Option[] options1, Option ... options2) {
        int size1 = 0;
        if (options1 != null && options1.length > 0) {
            size1 += options1.length;
        }
        int size2 = 0;
        if (options2 != null && options2.length > 0) {
            size2 += options2.length;
        }
        Option[] combined = new Option[size1 + size2];
        if (size1 > 0) {
            System.arraycopy(options1, 0, combined, 0, size1);
        }
        if (size2 > 0) {
            System.arraycopy(options2, 0, combined, size1, size2);
        }
        return combined;
    }

    public static <T extends Option> T[] filter(Class<T> optionType, Option ... options) {
        ArrayList<Option> filtered = new ArrayList<Option>();
        for (Option option : OptionUtils.expand(options)) {
            if (!optionType.isAssignableFrom(option.getClass())) continue;
            filtered.add(option);
        }
        Option[] result = (Option[])Array.newInstance(optionType, filtered.size());
        return filtered.toArray(result);
    }

    public static Option[] remove(Class<? extends Option> optionType, Option ... options) {
        ArrayList<Option> filtered = new ArrayList<Option>();
        for (Option option : OptionUtils.expand(options)) {
            if (optionType.isAssignableFrom(option.getClass())) continue;
            filtered.add(option);
        }
        return filtered.toArray(new Option[filtered.size()]);
    }
}

