/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameClassVisitor;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DefaultValuesExtractor {
    private DefaultValuesListener listener;
    private final List<Pattern> patternList = new ArrayList<Pattern>();
    private final HashSet<Pattern> patternSet = new HashSet();
    private ElementContentVisitor ecv = new ElementContentVisitor();
    private ElementsVisitor ev = new ElementsVisitor();

    public DefaultValuesExtractor(DefaultValuesListener defaultValuesListener) {
        this.listener = defaultValuesListener;
    }

    public void parsePattern(Pattern pattern) {
        pattern.apply(this.ecv);
        for (int i = 0; i < this.patternList.size(); ++i) {
            Pattern pattern2 = this.patternList.get(i);
            pattern2.apply(this.ev);
        }
    }

    private void addPattern(Pattern pattern) {
        if (!this.patternSet.contains(pattern)) {
            this.patternList.add(pattern);
            this.patternSet.add(pattern);
        }
    }

    public static interface DefaultValuesListener {
        public void defaultValue(String var1, String var2, String var3, String var4, String var5);
    }

    class ElementContentVisitor
    extends BaseVisitor {
        ElementContentVisitor() {
        }

        @Override
        public VoidValue caseElement(ElementPattern elementPattern) {
            DefaultValuesExtractor.this.addPattern(elementPattern);
            return VoidValue.VOID;
        }
    }

    class ElementsVisitor
    extends BaseVisitor {
        private List<Name> elements;

        ElementsVisitor() {
            this.elements = new ArrayList<Name>();
        }

        @Override
        public VoidValue caseElement(ElementPattern elementPattern) {
            this.elements.clear();
            elementPattern.getNameClass().accept(this);
            if (this.elements.size() > 0) {
                elementPattern.getContent().apply(new AttributesVisitor(this.elements));
            }
            elementPattern.getContent().apply(DefaultValuesExtractor.this.ecv);
            return VoidValue.VOID;
        }

        @Override
        public void visitName(Name name) {
            this.elements.add(name);
        }
    }

    class AttributesVisitor
    extends BaseVisitor {
        private String defaultValue;
        private List<Name> elements;

        public AttributesVisitor(List<Name> list) {
            this.elements = list;
        }

        @Override
        public VoidValue caseAttribute(AttributePattern attributePattern) {
            this.defaultValue = attributePattern.getDefaultValue();
            if (this.defaultValue != null) {
                attributePattern.getNameClass().accept(this);
            }
            return VoidValue.VOID;
        }

        @Override
        public void visitName(Name name) {
            for (Name name2 : this.elements) {
                DefaultValuesExtractor.this.listener.defaultValue(name2.getLocalName(), name2.getNamespaceUri(), name.getLocalName(), name.getNamespaceUri(), this.defaultValue);
            }
        }
    }

    class BaseVisitor
    implements PatternFunction<VoidValue>,
    NameClassVisitor {
        BaseVisitor() {
        }

        @Override
        public VoidValue caseElement(ElementPattern elementPattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseAttribute(AttributePattern attributePattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseError(ErrorPattern errorPattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseEmpty(EmptyPattern emptyPattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseNotAllowed(NotAllowedPattern notAllowedPattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseGroup(GroupPattern groupPattern) {
            groupPattern.getOperand1().apply(this);
            groupPattern.getOperand2().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseInterleave(InterleavePattern interleavePattern) {
            interleavePattern.getOperand1().apply(this);
            interleavePattern.getOperand2().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseChoice(ChoicePattern choicePattern) {
            choicePattern.getOperand1().apply(this);
            choicePattern.getOperand2().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.getOperand().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseData(DataPattern dataPattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseDataExcept(DataExceptPattern dataExceptPattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseValue(ValuePattern valuePattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseText(TextPattern textPattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseList(ListPattern listPattern) {
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseRef(RefPattern refPattern) {
            refPattern.getPattern().apply(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseAfter(AfterPattern afterPattern) {
            return VoidValue.VOID;
        }

        @Override
        public void visitName(Name name) {
        }

        @Override
        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }

        @Override
        public void visitNsName(String string) {
        }

        @Override
        public void visitNsNameExcept(String string, NameClass nameClass) {
        }

        @Override
        public void visitAnyName() {
        }

        @Override
        public void visitAnyNameExcept(NameClass nameClass) {
        }

        @Override
        public void visitNull() {
        }

        @Override
        public void visitError() {
        }
    }
}

