/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag.internal;

import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.ext.jekyll.tag.internal.JekyllTagParsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JekyllTagInlineParserExtension
implements InlineParserExtension {
    private final JekyllTagParsing parsing;
    private final boolean listIncludesOnly;

    public JekyllTagInlineParserExtension(LightInlineParser lightInlineParser) {
        this.parsing = new JekyllTagParsing(lightInlineParser.getParsing());
        this.listIncludesOnly = (Boolean)JekyllTagExtension.LIST_INCLUDES_ONLY.get((DataHolder)lightInlineParser.getDocument());
    }

    public void finalizeDocument(@NotNull InlineParser inlineParser) {
    }

    public void finalizeBlock(@NotNull InlineParser inlineParser) {
    }

    public boolean parse(@NotNull LightInlineParser inlineParser) {
        if (inlineParser.peek(1) == '%' && (inlineParser.peek(2) == ' ' || inlineParser.peek(2) == '\t')) {
            BasedSequence input = inlineParser.getInput();
            Matcher matcher = inlineParser.matcher(this.parsing.MACRO_TAG);
            if (matcher != null) {
                BasedSequence tag = input.subSequence(matcher.start(), matcher.end());
                BasedSequence tagName = input.subSequence(matcher.start(1), matcher.end(1));
                BasedSequence parameters = (BasedSequence)input.subSequence(matcher.end(1), matcher.end() - 2).trim();
                JekyllTag macro = new JekyllTag(tag.subSequence(0, 2), tagName, parameters, (BasedSequence)tag.endSequence(2));
                macro.setCharsFromContent();
                if (!this.listIncludesOnly || tagName.equals("include")) {
                    List tagList = (List)JekyllTagExtension.TAG_LIST.get((DataHolder)inlineParser.getDocument());
                    tagList.add(macro);
                }
                inlineParser.flushTextNode();
                inlineParser.getBlock().appendChild((Node)macro);
                return true;
            }
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @NotNull
        public CharSequence getCharacters() {
            return "{";
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @NotNull
        public InlineParserExtension apply(@NotNull LightInlineParser lightInlineParser) {
            return new JekyllTagInlineParserExtension(lightInlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

