/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown;

import com.elovirta.dita.markdown.DitaRenderer;
import com.elovirta.dita.markdown.MDitaReader;
import com.elovirta.dita.markdown.MarkdownParser;
import com.elovirta.dita.markdown.MarkdownParserImpl;
import com.elovirta.dita.markdown.SchemaProvider;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.definition.DefinitionExtension;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.ins.InsExtension;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.ext.superscript.SuperscriptExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultSchemaProvider
implements SchemaProvider {
    private static final Map<URI, DataSet> SCHEMA_OPTIONS;

    @Override
    public boolean isSupportedSchema(URI schema) {
        return SCHEMA_OPTIONS.containsKey(schema);
    }

    @Override
    public MarkdownParser createMarkdownParser(URI schema) {
        return new MarkdownParserImpl(SCHEMA_OPTIONS.get(schema));
    }

    static {
        DataSet options = new MutableDataSet().set(Parser.EXTENSIONS, Arrays.asList(AbbreviationExtension.create(), AnchorLinkExtension.create(), AttributesExtension.create(), FootnoteExtension.create(), InsExtension.create(), JekyllTagExtension.create(), SuperscriptExtension.create(), TablesExtension.create(), AutolinkExtension.create(), YamlFrontMatterExtension.create(), DefinitionExtension.create(), StrikethroughSubscriptExtension.create())).set(DefinitionExtension.TILDE_MARKER, (Object)false).set(TablesExtension.COLUMN_SPANS, (Object)true).set(TablesExtension.APPEND_MISSING_COLUMNS, (Object)false).set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true).set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)true).set(DitaRenderer.SHORTDESC_PARAGRAPH, (Object)true).set(DitaRenderer.FIX_ROOT_HEADING, (Object)true).set(DitaRenderer.ID_FROM_YAML, (Object)true).toImmutable();
        DataSet optionsConcept = new MutableDataSet((DataHolder)options).set(DitaRenderer.SPECIALIZATION_CONCEPT, (Object)true).toImmutable();
        DataSet optionsTask = new MutableDataSet((DataHolder)options).set(DitaRenderer.SPECIALIZATION_TASK, (Object)true).toImmutable();
        DataSet optionsReference = new MutableDataSet((DataHolder)options).set(DitaRenderer.SPECIALIZATION_REFERENCE, (Object)true).toImmutable();
        DataSet optionsMap = new MutableDataSet().set(Parser.EXTENSIONS, Arrays.asList(AnchorLinkExtension.create(), JekyllTagExtension.create(), TablesExtension.create(), YamlFrontMatterExtension.create())).set(TablesExtension.COLUMN_SPANS, (Object)false).set(TablesExtension.APPEND_MISSING_COLUMNS, (Object)false).set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true).set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)true).set(DitaRenderer.ID_FROM_YAML, (Object)true).set(DitaRenderer.MAP, (Object)true).toImmutable();
        HashMap<URI, DataSet> schemas = new HashMap<URI, DataSet>();
        schemas.put(URI.create("urn:oasis:names:tc:dita:xsd:topic.xsd"), options);
        schemas.put(URI.create("urn:oasis:names:tc:dita:rng:topic.rng"), options);
        schemas.put(URI.create("urn:oasis:names:tc:dita:xsd:concept.xsd"), optionsConcept);
        schemas.put(URI.create("urn:oasis:names:tc:dita:rng:concept.rng"), optionsConcept);
        schemas.put(URI.create("urn:oasis:names:tc:dita:xsd:task.xsd"), optionsTask);
        schemas.put(URI.create("urn:oasis:names:tc:dita:rng:task.rng"), optionsTask);
        schemas.put(URI.create("urn:oasis:names:tc:dita:xsd:reference.xsd"), optionsReference);
        schemas.put(URI.create("urn:oasis:names:tc:dita:rng:reference.rng"), optionsReference);
        schemas.put(URI.create("urn:oasis:names:tc:dita:xsd:map.xsd"), optionsMap);
        schemas.put(URI.create("urn:oasis:names:tc:dita:rng:map.rng"), optionsMap);
        schemas.put(URI.create("urn:oasis:names:tc:mdita:xsd:topic.xsd"), MDitaReader.EXTENDED_PROFILE);
        schemas.put(URI.create("urn:oasis:names:tc:mdita:rng:topic.rng"), MDitaReader.EXTENDED_PROFILE);
        schemas.put(URI.create("urn:oasis:names:tc:mdita:extended:xsd:topic.xsd"), MDitaReader.EXTENDED_PROFILE);
        schemas.put(URI.create("urn:oasis:names:tc:mdita:extended:rng:topic.rng"), MDitaReader.EXTENDED_PROFILE);
        schemas.put(URI.create("urn:oasis:names:tc:mdita:core:xsd:topic.xsd"), MDitaReader.CORE_PROFILE);
        schemas.put(URI.create("urn:oasis:names:tc:mdita:core:rng:topic.rng"), MDitaReader.CORE_PROFILE);
        SCHEMA_OPTIONS = Collections.unmodifiableMap(schemas);
    }
}

