/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.util.Map;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;

public class ImageLoaderPDF
extends AbstractImageLoader {
    private ImageFlavor targetFlavor;

    public ImageLoaderPDF(ImageFlavor targetFlavor) {
        if (!ImagePDF.PDFBOX_IMAGE.equals((Object)targetFlavor)) {
            throw new IllegalArgumentException("Unsupported target ImageFlavor: " + targetFlavor);
        }
        this.targetFlavor = targetFlavor;
    }

    public ImageFlavor getTargetFlavor() {
        return this.targetFlavor;
    }

    public Image loadImage(ImageInfo info, Map hints, ImageSessionContext session) throws ImageException, IOException {
        if (!"application/pdf".equals(info.getMimeType())) {
            throw new IllegalArgumentException("ImageInfo must be from a PDF document");
        }
        Image img = info.getOriginalImage();
        if (!(img instanceof ImagePDF)) {
            throw new IllegalArgumentException("ImageInfo was expected to contain the PDF document");
        }
        ImagePDF pdfImage = (ImagePDF)img;
        return pdfImage;
    }
}

