/*
 * Decompiled with CFR 0.152.
 */
package com.idiominc.ws.opentopic.fo.i18n;

import com.idiominc.ws.opentopic.fo.i18n.Alphabet;
import com.idiominc.ws.opentopic.fo.i18n.ConfigurationException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Configuration {
    private static final String BAD_CONF_MESSAGE = "Bad configuration file format!";
    private final Alphabet[] alphabets;

    public Configuration(Document theConfigurationFile) throws ConfigurationException {
        this.alphabets = this.initAlphabets(theConfigurationFile);
    }

    public Alphabet[] getAlphabets() {
        return this.alphabets;
    }

    public Alphabet getAlphabetForChar(char theChar) {
        Alphabet result = null;
        for (Alphabet alphabet : this.alphabets) {
            if (!alphabet.isContain(theChar)) continue;
            result = alphabet;
            break;
        }
        return result;
    }

    private Alphabet[] initAlphabets(Document theConfigurationFile) throws ConfigurationException {
        ArrayList<Alphabet> alphabetList = new ArrayList<Alphabet>();
        Element firstChild = theConfigurationFile.getDocumentElement();
        if (!"configuration".equals(firstChild.getNodeName())) {
            throw new ConfigurationException(BAD_CONF_MESSAGE);
        }
        NodeList alphabets = firstChild.getChildNodes();
        for (int i = 0; i < alphabets.getLength(); ++i) {
            Node alphabet = alphabets.item(i);
            if (!"alphabet".equals(alphabet.getNodeName()) || alphabet.getAttributes() == null || alphabet.getAttributes().getNamedItem("char-set") == null) continue;
            String charSetName = alphabet.getAttributes().getNamedItem("char-set").getNodeValue();
            NodeList alphabetChildNodes = alphabet.getChildNodes();
            for (int j = 0; j < alphabetChildNodes.getLength(); ++j) {
                Node alphabetChildNode = alphabetChildNodes.item(j);
                String childNodeName = alphabetChildNode.getNodeName();
                if (!"character-set".equals(childNodeName)) continue;
                Character[] chars = this.processCharacterSetNode(alphabetChildNode);
                alphabetList.add(new Alphabet(charSetName, chars));
            }
        }
        return alphabetList.toArray(new Alphabet[0]);
    }

    private Character[] processCharacterSetNode(Node theNode) throws ConfigurationException {
        ArrayList<Character> characterList = new ArrayList<Character>();
        NodeList ranges = theNode.getChildNodes();
        for (int i = 0; i < ranges.getLength(); ++i) {
            Node node = ranges.item(i);
            if ("character".equals(node.getNodeName())) {
                char[] aChars = node.getFirstChild().getNodeValue().toCharArray();
                if (aChars.length != 1) {
                    throw new ConfigurationException(BAD_CONF_MESSAGE);
                }
                characterList.add(Character.valueOf(aChars[0]));
                continue;
            }
            if (!"character-range".equals(node.getNodeName())) continue;
            Node start = null;
            Node end = null;
            NodeList childNodes = node.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node aNode = childNodes.item(j);
                if ("start".equals(aNode.getNodeName())) {
                    start = aNode;
                    continue;
                }
                if (!"end".equals(aNode.getNodeName())) continue;
                end = aNode;
            }
            if (null == start || null == end) {
                throw new ConfigurationException(BAD_CONF_MESSAGE);
            }
            char[] startChars = start.getFirstChild().getNodeValue().toCharArray();
            char[] endChars = end.getFirstChild().getNodeValue().toCharArray();
            if (startChars.length != 1 || endChars.length != 1) {
                throw new ConfigurationException(BAD_CONF_MESSAGE);
            }
            char startChar = startChars[0];
            char endChar = endChars[0];
            for (char ch = startChar; ch <= endChar; ch = (char)(ch + '\u0001')) {
                characterList.add(Character.valueOf(ch));
            }
        }
        return characterList.toArray(new Character[0]);
    }
}

