/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.actions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AttachWindowAction
extends Action {
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String AS_LAST_TAB = "As a Last Tab";
    private static final String windowItem = Bundle.getStringTrimmed("org.netbeans.core.windows.resources.Bundle", "Menu/Window");
    private String sideConstant;
    private String targetTopComponentName;
    private TopComponentOperator targetTopComponentOperator;

    public AttachWindowAction(String string, String string2) {
        super(null, null);
        if (string == null) {
            throw new IllegalArgumentException("targetTopComponentName cannot be null.");
        }
        this.targetTopComponentName = string;
        this.mapSide(string2);
    }

    public AttachWindowAction(TopComponentOperator topComponentOperator, String string) {
        super(null, null);
        if (topComponentOperator == null) {
            throw new IllegalArgumentException("targetTopComponentOperator cannot be null.");
        }
        this.targetTopComponentOperator = topComponentOperator;
        this.mapSide(string);
    }

    private TopComponentOperator getTargetTopComponentOperator() {
        if (this.targetTopComponentOperator == null) {
            this.targetTopComponentOperator = new TopComponentOperator(this.targetTopComponentName);
        }
        return this.targetTopComponentOperator;
    }

    private void mapSide(String string) {
        if (string == null || string.equals(AS_LAST_TAB)) {
            this.sideConstant = AS_LAST_TAB;
        } else if (string.equals(RIGHT)) {
            this.sideConstant = RIGHT;
        } else if (string.equals(LEFT)) {
            this.sideConstant = LEFT;
        } else if (string.equals(TOP)) {
            this.sideConstant = TOP;
        } else if (string.equals(BOTTOM)) {
            this.sideConstant = BOTTOM;
        } else {
            throw new JemmyException("Cannot attach to position \"" + string + "\".");
        }
    }

    @Override
    public void performAPI(ComponentOperator componentOperator) {
        if (!(componentOperator instanceof TopComponentOperator)) {
            throw new UnsupportedOperationException("AttachWindowAction can only be called on TopComponentOperator.");
        }
        this.performAPI((TopComponentOperator)componentOperator);
    }

    public void performAPI(TopComponentOperator topComponentOperator) {
        final TopComponent topComponent = (TopComponent)topComponentOperator.getSource();
        final TopComponent topComponent2 = (TopComponent)this.getTargetTopComponentOperator().getSource();
        topComponentOperator.getQueueTool().invokeSmoothly(new Runnable(){

            @Override
            public void run() {
                Mode mode = WindowManager.getDefault().findMode(topComponent2);
                if (AttachWindowAction.this.sideConstant.equals(AttachWindowAction.AS_LAST_TAB)) {
                    mode.dockInto(topComponent);
                    topComponent.open();
                    topComponent.requestActive();
                } else {
                    AttachWindowAction.attachTopComponent(topComponent, mode, AttachWindowAction.this.sideConstant);
                }
            }
        });
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return ((TopComponent)object).isShowing() ? Boolean.TRUE : null;
                }

                public String getDescription() {
                    return "TopComponent is showing.";
                }
            }).waitAction((Object)topComponent);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    static Object callWindowManager(String string, Object ... objectArray) {
        return AttachWindowAction.callWindowManager(WindowManager.getDefault().getClass(), string, objectArray);
    }

    private static Object callWindowManager(Class<?> clazz, String string, Object ... objectArray) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!string.equals(method.getName()) || objectArray == null && method.getParameterTypes().length > 0 || objectArray != null && method.getParameterTypes().length != objectArray.length) continue;
            try {
                return method.invoke((Object)WindowManager.getDefault(), objectArray);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot execute " + string, exception);
            }
        }
        return AttachWindowAction.callWindowManager(clazz.getSuperclass(), string, objectArray);
    }

    private static Class<?> classForName(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
    }

    private static void attachTopComponent(TopComponent topComponent, Mode mode, String string) {
        try {
            Class<?> clazz = AttachWindowAction.classForName("org.netbeans.core.windows.Central");
            Class<?> clazz2 = AttachWindowAction.classForName("org.netbeans.core.windows.view.dnd.TopComponentDraggable");
            Class<?> clazz3 = AttachWindowAction.classForName("org.netbeans.core.windows.ModeImpl");
            Method method = clazz.getMethod("userDroppedTopComponents", clazz3, clazz2, String.class);
            Method method2 = WindowManager.getDefault().getClass().getDeclaredMethod("getCentral", null);
            method2.setAccessible(true);
            Object object = method2.invoke((Object)WindowManager.getDefault(), (Object[])null);
            Constructor<?> constructor = clazz2.getDeclaredConstructor(TopComponent.class);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(topComponent);
            method.setAccessible(true);
            method.invoke(object, mode, obj, string);
        }
        catch (Exception exception) {
            throw new JemmyException("Cannot attach TopComponent.", (Throwable)exception);
        }
    }

    @Override
    public void performAPI(Node[] nodeArray) {
        throw new UnsupportedOperationException("AttachWindowAction doesn't have popup representation on nodes.");
    }

    @Override
    public void performMenu(Node[] nodeArray) {
        throw new UnsupportedOperationException("AttachWindowAction doesn't have popup representation on nodes.");
    }

    @Override
    public void performPopup(Node[] nodeArray) {
        throw new UnsupportedOperationException("AttachWindowAction doesn't have popup representation on nodes.");
    }

    @Override
    public void performShortcut(Node[] nodeArray) {
        throw new UnsupportedOperationException("AttachWindowAction doesn't have popup representation on nodes.");
    }
}

