/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.DefaultNativeComponent;
import org.gradle.language.nativeplatform.internal.Names;

public abstract class DefaultCppComponent
extends DefaultNativeComponent
implements CppComponent,
ComponentWithNames {
    private final FileCollection cppSource;
    private final String name;
    private final FileCollection privateHeadersWithConvention;
    private final Names names;
    private final DefaultBinaryCollection<CppBinary> binaries;

    @Inject
    public DefaultCppComponent(String name) {
        this.name = name;
        this.cppSource = this.createSourceView("src/" + name + "/cpp", Arrays.asList("cpp", "c++", "cc"));
        this.privateHeadersWithConvention = this.createDirView(this.getPrivateHeaders(), "src/" + name + "/headers");
        this.names = Names.of(name);
        this.binaries = (DefaultBinaryCollection)Cast.uncheckedCast((Object)this.getObjectFactory().newInstance(DefaultBinaryCollection.class, new Object[]{CppBinary.class}));
    }

    @Override
    public Names getNames() {
        return this.names;
    }

    public String getName() {
        return this.name;
    }

    protected FileCollection createDirView(final ConfigurableFileCollection dirs, final String conventionLocation) {
        return this.getProjectLayout().files(new Object[]{new Callable<Object>(){

            @Override
            public Object call() {
                if (dirs.getFrom().isEmpty()) {
                    return DefaultCppComponent.this.getProjectLayout().getProjectDirectory().dir(conventionLocation);
                }
                return dirs;
            }
        }});
    }

    @Override
    public FileCollection getCppSource() {
        return this.cppSource;
    }

    @Override
    public void privateHeaders(Action<? super ConfigurableFileCollection> action) {
        action.execute((Object)this.getPrivateHeaders());
    }

    @Override
    public FileCollection getPrivateHeaderDirs() {
        return this.privateHeadersWithConvention;
    }

    @Override
    public FileTree getHeaderFiles() {
        PatternSet patterns = new PatternSet();
        patterns.include(new String[]{"**/*.h"});
        patterns.include(new String[]{"**/*.hpp"});
        patterns.include(new String[]{"**/*.h++"});
        patterns.include(new String[]{"**/*.hxx"});
        patterns.include(new String[]{"**/*.hm"});
        patterns.include(new String[]{"**/*.inl"});
        patterns.include(new String[]{"**/*.inc"});
        patterns.include(new String[]{"**/*.xsd"});
        return this.getAllHeaderDirs().getAsFileTree().matching((PatternFilterable)patterns);
    }

    public FileCollection getAllHeaderDirs() {
        return this.privateHeadersWithConvention;
    }

    public DefaultBinaryCollection<CppBinary> getBinaries() {
        return this.binaries;
    }
}

