/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.util.internal.GUtil;

public class Path
implements Comparable<Path> {
    public static final Path ROOT = new Path(new String[0], true);
    private static final Comparator<String> STRING_COMPARATOR = GUtil.caseInsensitive();
    public static final String SEPARATOR = ":";
    private final String[] segments;
    private final boolean absolute;
    private final int hashCode;
    private volatile String fullPath;

    public static Path path(@Nullable String path) {
        Path.validatePath(path);
        if (SEPARATOR.equals(path)) {
            return ROOT;
        }
        return Path.parsePath(path);
    }

    @Incubating
    public static void validatePath(@Nullable String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
    }

    private static Path parsePath(String path) {
        String[] segments = StringUtils.split((String)path, (String)SEPARATOR);
        boolean absolute = path.startsWith(SEPARATOR);
        return new Path(segments, absolute);
    }

    private Path(String[] segments, boolean absolute) {
        this.segments = segments;
        this.absolute = absolute;
        this.hashCode = Path.computeHashCode(absolute, segments);
    }

    public String toString() {
        return this.getPath();
    }

    public Path append(Path path) {
        if (path.segments.length == 0) {
            return this;
        }
        String[] concat = new String[this.segments.length + path.segments.length];
        System.arraycopy(this.segments, 0, concat, 0, this.segments.length);
        System.arraycopy(path.segments, 0, concat, this.segments.length, path.segments.length);
        return new Path(concat, this.absolute);
    }

    public String getPath() {
        if (this.fullPath == null) {
            this.fullPath = this.createFullPath();
        }
        return this.fullPath;
    }

    private String createFullPath() {
        StringBuilder path = new StringBuilder();
        if (this.absolute) {
            path.append(SEPARATOR);
        }
        return path.append(StringUtils.join((Object[])this.segments, (String)SEPARATOR)).toString();
    }

    @Incubating
    public List<String> segments() {
        return Arrays.asList(this.segments);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        if (this.absolute != path.absolute) {
            return false;
        }
        return Arrays.equals(this.segments, path.segments);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static int computeHashCode(boolean absolute, String[] segments) {
        int result = 0;
        for (String element : segments) {
            result = 31 * result + element.hashCode();
        }
        result = 31 * result + (absolute ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(Path other) {
        if (this.absolute && !other.absolute) {
            return 1;
        }
        if (!this.absolute && other.absolute) {
            return -1;
        }
        for (int i = 0; i < Math.min(this.segments.length, other.segments.length); ++i) {
            int diff = STRING_COMPARATOR.compare(this.segments[i], other.segments[i]);
            if (diff == 0) continue;
            return diff;
        }
        int lenDiff = this.segments.length - other.segments.length;
        if (lenDiff > 0) {
            return 1;
        }
        if (lenDiff < 0) {
            return -1;
        }
        return 0;
    }

    @Nullable
    public Path getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        if (this.segments.length == 1) {
            return this.absolute ? ROOT : null;
        }
        String[] parentPath = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, parentPath, 0, parentPath.length);
        return new Path(parentPath, this.absolute);
    }

    @Nullable
    public String getName() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public Path child(String name) {
        String[] childSegments = new String[this.segments.length + 1];
        System.arraycopy(this.segments, 0, childSegments, 0, this.segments.length);
        childSegments[this.segments.length] = name;
        return new Path(childSegments, this.absolute);
    }

    public String absolutePath(String path) {
        return this.absolutePath(Path.path(path)).getPath();
    }

    public Path absolutePath(Path path) {
        if (path.absolute) {
            return path;
        }
        return this.append(path);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public String relativePath(String path) {
        return this.relativePath(Path.path(path)).getPath();
    }

    public Path relativePath(Path path) {
        if (path.absolute != this.absolute) {
            return path;
        }
        if (path.segments.length < this.segments.length) {
            return path;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (path.segments[i].equals(this.segments[i])) continue;
            return path;
        }
        if (path.segments.length == this.segments.length) {
            return path;
        }
        return new Path(Arrays.copyOfRange(path.segments, this.segments.length, path.segments.length), false);
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public Path removeFirstSegments(int n) {
        if (n == 0) {
            return this;
        }
        if (n == this.segments.length && this.absolute) {
            return ROOT;
        }
        if (n < 0 || n >= this.segments.length) {
            throw new IllegalArgumentException("Cannot remove " + n + " segments from path " + this.getPath());
        }
        return new Path(Arrays.copyOfRange(this.segments, n, this.segments.length), this.absolute);
    }

    public String segment(int index) {
        if (index < 0 || index >= this.segments.length) {
            throw new IllegalArgumentException("Segment index " + index + " is invalid for path " + this.getPath());
        }
        return this.segments[index];
    }

    @Incubating
    public Path takeFirstSegments(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Taken path segment count must be >= 1.");
        }
        if (n >= this.segmentCount()) {
            return this;
        }
        return new Path(Arrays.copyOfRange(this.segments, 0, Math.min(n, this.segmentCount())), this.absolute);
    }
}

