/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.RepositoriesSupplier;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResolvedConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ShortCircuitingResolutionExecutor;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.DefaultVisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolutionResultGraphBuilder;
import org.gradle.api.internal.artifacts.repositories.ContentFilteringRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.model.CalculatedValue;

public class DefaultConfigurationResolver
implements ConfigurationResolver {
    private final RepositoriesSupplier repositoriesSupplier;
    private final ShortCircuitingResolutionExecutor resolutionExecutor;
    private final AttributeDesugaring attributeDesugaring;

    public DefaultConfigurationResolver(RepositoriesSupplier repositoriesSupplier, ShortCircuitingResolutionExecutor resolutionExecutor, AttributeDesugaring attributeDesugaring) {
        this.repositoriesSupplier = repositoriesSupplier;
        this.resolutionExecutor = resolutionExecutor;
        this.attributeDesugaring = attributeDesugaring;
    }

    @Override
    public ResolverResults resolveBuildDependencies(ConfigurationInternal configuration, CalculatedValue<ResolverResults> futureCompleteResults) {
        RootComponentMetadataBuilder.RootComponentState rootComponent = configuration.toRootComponent();
        VisitedGraphResults missingConfigurationResults = this.maybeGetEmptyGraphForInvalidMissingConfigurationWithNoDependencies(configuration, rootComponent.getRootComponent());
        if (missingConfigurationResults != null) {
            return DefaultResolverResults.buildDependenciesResolved(missingConfigurationResults, ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE, DefaultResolverResults.DefaultLegacyResolverResults.buildDependenciesResolved(ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE));
        }
        return this.resolutionExecutor.resolveBuildDependencies(configuration, futureCompleteResults);
    }

    @Override
    public ResolverResults resolveGraph(ConfigurationInternal configuration) {
        RootComponentMetadataBuilder.RootComponentState rootComponent = configuration.toRootComponent();
        VisitedGraphResults missingConfigurationResults = this.maybeGetEmptyGraphForInvalidMissingConfigurationWithNoDependencies(configuration, rootComponent.getRootComponent());
        if (missingConfigurationResults != null) {
            DefaultResolvedConfiguration resolvedConfiguration = new DefaultResolvedConfiguration(missingConfigurationResults, configuration.getResolutionHost(), ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE, new ShortCircuitingResolutionExecutor.EmptyLenientConfiguration());
            return DefaultResolverResults.graphResolved(missingConfigurationResults, ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE, DefaultResolverResults.DefaultLegacyResolverResults.graphResolved(ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE, resolvedConfiguration));
        }
        ImmutableAttributes attributes = configuration.toRootComponent().getRootVariant().getAttributes();
        List<ResolutionAwareRepository> filteredRepositories = ((List)this.repositoriesSupplier.get()).stream().filter(arg_0 -> DefaultConfigurationResolver.lambda$resolveGraph$0(configuration, (AttributeContainerInternal)attributes, arg_0)).collect(Collectors.toList());
        return this.resolutionExecutor.resolveGraph(configuration, filteredRepositories);
    }

    @Override
    public List<ResolutionAwareRepository> getAllRepositories() {
        return (List)this.repositoriesSupplier.get();
    }

    private static boolean shouldSkipRepository(ResolutionAwareRepository repository, String resolveContextName, AttributeContainer consumerAttributes) {
        if (!(repository instanceof ContentFilteringRepository)) {
            return false;
        }
        ContentFilteringRepository cfr = (ContentFilteringRepository)((Object)repository);
        Set<String> includedConfigurations = cfr.getIncludedConfigurations();
        Set<String> excludedConfigurations = cfr.getExcludedConfigurations();
        if (includedConfigurations != null && !includedConfigurations.contains(resolveContextName) || excludedConfigurations != null && excludedConfigurations.contains(resolveContextName)) {
            return true;
        }
        Map<Attribute<Object>, Set<Object>> requiredAttributes = cfr.getRequiredAttributes();
        return DefaultConfigurationResolver.hasNonRequiredAttribute(requiredAttributes, consumerAttributes);
    }

    private static boolean hasNonRequiredAttribute(@Nullable Map<Attribute<Object>, Set<Object>> requiredAttributes, AttributeContainer consumerAttributes) {
        if (requiredAttributes == null) {
            return false;
        }
        for (Map.Entry<Attribute<Object>, Set<Object>> entry : requiredAttributes.entrySet()) {
            Object value;
            Attribute<Object> key = entry.getKey();
            Set<Object> allowedValues = entry.getValue();
            if (allowedValues.contains(value = consumerAttributes.getAttribute(key))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private VisitedGraphResults maybeGetEmptyGraphForInvalidMissingConfigurationWithNoDependencies(ConfigurationInternal configuration, LocalComponentGraphResolveState rootComponent) {
        LocalVariantGraphResolveState rootVariant = rootComponent.getConfigurationLegacy(configuration.getName());
        if (rootVariant == null) {
            configuration.runDependencyActions();
            if (configuration.getAllDependencies().isEmpty()) {
                ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Removing a configuration from the container before resolution").withAdvice("Do not remove configurations from the container and resolve them after.")).willBecomeAnErrorInGradle9().undocumented()).nagUser();
                MinimalResolutionResult emptyResult = ResolutionResultGraphBuilder.empty(rootComponent.getModuleVersionId(), rootComponent.getId(), configuration.getAttributes().asImmutable(), ImmutableCapabilities.of((Capability)rootComponent.getDefaultCapability()), configuration.getName(), this.attributeDesugaring);
                return new DefaultVisitedGraphResults(emptyResult, Collections.emptySet(), null);
            }
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$resolveGraph$0(ConfigurationInternal configuration, AttributeContainerInternal attributes, ResolutionAwareRepository repository) {
        return !DefaultConfigurationResolver.shouldSkipRepository(repository, configuration.getName(), (AttributeContainer)attributes);
    }
}

