/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.internal.ConfigurationCacheDegradationController;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.vcs.internal.VcsMappingsStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\rJ&\u0010!\u001a\u00020\"2\u001e\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000e\u0012\u0004\u0012\u00020\"0$J&\u0010%\u001a\u00020\"2\u001e\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000e\u0012\u0004\u0012\u00020\"0$J\u001e\u0010&\u001a\u00020\"2\u0006\u0010 \u001a\u00020\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0006\u0010(\u001a\u00020\"J\b\u0010)\u001a\u00020\"H\u0002J\b\u0010*\u001a\u00020\"H\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\rH\u0002J\b\u0010,\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u0013\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u0013\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lorg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController;", "Lorg/gradle/api/internal/ConfigurationCacheDegradationController;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "vcsMappingsStore", "Lorg/gradle/vcs/internal/VcsMappingsStore;", "<init>", "(Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;Lorg/gradle/vcs/internal/VcsMappingsStore;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "tasksDegradationRequests", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/gradle/api/Task;", "", "Lorg/gradle/api/provider/Provider;", "", "taskDegradationReasons", "Lcom/google/common/collect/ImmutableMap;", "Lkotlin/jvm/internal/EnhancedNullability;", "featureDegradationReasons", "hasDegradationReasons", "", "getHasDegradationReasons", "()Z", "hasTaskDegradationReasons", "getHasTaskDegradationReasons", "degradedTaskCount", "", "getDegradedTaskCount", "()I", "getDegradationReasonsForTask", "task", "visitDegradedTasks", "", "consumer", "Lkotlin/Function2;", "visitDegradedFeatures", "requireConfigurationCacheDegradation", "reason", "collectDegradationReasons", "collectTaskDegradationReasons", "collectFeatureDegradationReasons", "workGraphContains", "isSourceDependenciesUsed", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nDefaultConfigurationCacheDegradationController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultConfigurationCacheDegradationController.kt\norg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1617#2,9:111\n1869#2:120\n1870#2:122\n1626#2:123\n1#3:121\n*S KotlinDebug\n*F\n+ 1 DefaultConfigurationCacheDegradationController.kt\norg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController\n*L\n83#1:111,9\n83#1:120\n83#1:122\n83#1:123\n83#1:121\n*E\n"})
public final class DefaultConfigurationCacheDegradationController
implements ConfigurationCacheDegradationController {
    @NotNull
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    @NotNull
    private final VcsMappingsStore vcsMappingsStore;
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<Task, List<Provider<String>>> tasksDegradationRequests;
    @NotNull
    private ImmutableMap<Task, List<String>> taskDegradationReasons;
    @NotNull
    private ImmutableMap<String, List<String>> featureDegradationReasons;

    public DefaultConfigurationCacheDegradationController(@NotNull ConfigurationTimeBarrier configurationTimeBarrier, @NotNull VcsMappingsStore vcsMappingsStore) {
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        Intrinsics.checkNotNullParameter((Object)vcsMappingsStore, (String)"vcsMappingsStore");
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.vcsMappingsStore = vcsMappingsStore;
        this.logger = Logging.getLogger(DefaultConfigurationCacheDegradationController.class);
        this.tasksDegradationRequests = new ConcurrentHashMap();
        ImmutableMap immutableMap = ImmutableMap.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
        this.taskDegradationReasons = immutableMap;
        ImmutableMap immutableMap2 = ImmutableMap.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap2, (String)"of(...)");
        this.featureDegradationReasons = immutableMap2;
    }

    public final boolean getHasDegradationReasons() {
        return !((Map)this.taskDegradationReasons).isEmpty() || !((Map)this.featureDegradationReasons).isEmpty();
    }

    public final boolean getHasTaskDegradationReasons() {
        return !((Map)this.taskDegradationReasons).isEmpty();
    }

    public final int getDegradedTaskCount() {
        return this.taskDegradationReasons.size();
    }

    @Nullable
    public final List<String> getDegradationReasonsForTask(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return (List)this.taskDegradationReasons.get((Object)task);
    }

    public final void visitDegradedTasks(@NotNull Function2<? super Task, ? super List<String>, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.taskDegradationReasons.forEach(new BiConsumer(consumer){
            private final /* synthetic */ Function2 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void accept(Object p0, Object p1) {
                this.function.invoke(p0, p1);
            }
        });
    }

    public final void visitDegradedFeatures(@NotNull Function2<? super String, ? super List<String>, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.featureDegradationReasons.forEach(new /* invalid duplicate definition of identical inner class */);
    }

    public void requireConfigurationCacheDegradation(@NotNull Task task, @NotNull Provider<String> reason) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(reason, (String)"reason");
        if (!this.configurationTimeBarrier.isAtConfigurationTime()) {
            this.logger.debug("Configuration cache degradation request of task {} is ignored at execution time", (Object)task.getPath());
            return;
        }
        this.tasksDegradationRequests.compute(task, new BiFunction(reason){
            final /* synthetic */ Provider<String> $reason;
            {
                this.$reason = $reason;
            }

            public final List<Provider<String>> apply(Task task, List<? extends Provider<String>> reasons) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"<unused var>");
                List list = reasons;
                if (list == null || (list = CollectionsKt.plus((Collection)list, this.$reason)) == null) {
                    list = CollectionsKt.listOf(this.$reason);
                }
                return list;
            }
        });
    }

    public final void collectDegradationReasons() {
        this.collectFeatureDegradationReasons();
        this.collectTaskDegradationReasons();
    }

    /*
     * WARNING - void declaration
     */
    private final void collectTaskDegradationReasons() {
        if (!((Map)this.tasksDegradationRequests).isEmpty()) {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)this.tasksDegradationRequests.size());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builderWithExpectedSize(...)");
            ImmutableMap.Builder builder2 = builder;
            for (Map.Entry entry : ((Map)this.tasksDegradationRequests).entrySet()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Task task = (Task)entry.getKey();
                List reasons = (List)entry.getValue();
                if (!this.workGraphContains(task)) continue;
                Iterable iterable = reasons;
                boolean $i$f$mapNotNull = false;
                void var9_9 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Provider it2 = (Provider)element$iv$iv;
                    boolean bl2 = false;
                    if ((String)it2.getOrNull() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List reasonsInEffect = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                if (!(!((Collection)reasonsInEffect).isEmpty())) continue;
                builder2.put((Object)task, (Object)reasonsInEffect);
            }
            ImmutableMap immutableMap = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"build(...)");
            this.taskDegradationReasons = immutableMap;
        }
    }

    private final void collectFeatureDegradationReasons() {
        if (this.isSourceDependenciesUsed()) {
            ImmutableMap immutableMap = ImmutableMap.of((Object)"source dependencies", (Object)CollectionsKt.listOf((Object)"Source dependencies are not compatible yet"));
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
            this.featureDegradationReasons = immutableMap;
        }
    }

    private final boolean workGraphContains(Task task) {
        return task.getProject().getGradle().getTaskGraph().hasTask(task);
    }

    private final boolean isSourceDependenciesUsed() {
        return this.vcsMappingsStore.asResolver().hasRules();
    }
}

