/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import java.io.File;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.ChangingOutputsContext;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.file.TreeType;

public class BroadcastChangingOutputsStep<C extends InputChangesContext>
implements Step<C, Result> {
    private final OutputChangeListener outputChangeListener;
    private final Step<? super ChangingOutputsContext, ? extends Result> delegate;

    public BroadcastChangingOutputsStep(OutputChangeListener outputChangeListener, Step<? super ChangingOutputsContext, ? extends Result> delegate) {
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(UnitOfWork work, C context) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        work.visitOutputs(((WorkspaceContext)context).getWorkspace(), new UnitOfWork.OutputVisitor(){

            @Override
            public void visitOutputProperty(String propertyName, TreeType type, UnitOfWork.OutputFileValueSupplier value) {
                builder.add((Object)value.getValue().getAbsolutePath());
            }

            @Override
            public void visitLocalState(File localStateRoot) {
                builder.add((Object)localStateRoot.getAbsolutePath());
            }

            @Override
            public void visitDestroyable(File destroyableRoot) {
                builder.add((Object)destroyableRoot.getAbsolutePath());
            }
        });
        ImmutableList outputsToBeChanged = builder.build();
        this.outputChangeListener.invalidateCachesFor((Iterable<String>)outputsToBeChanged);
        try {
            Result result = this.delegate.execute(work, new ChangingOutputsContext((InputChangesContext)context));
            return result;
        }
        finally {
            this.outputChangeListener.invalidateCachesFor((Iterable<String>)outputsToBeChanged);
        }
    }
}

