/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.Job;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.XMLFilter;

public final class XmlFilterModule
extends AbstractPipelineModuleImpl {
    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Collection<Job.FileInfo> fis = this.job.getFileInfo(this.fileInfoFilter);
        if (this.parallel) {
            ((Stream)fis.stream().parallel()).forEach(f -> {
                URI file = this.job.tempDirURI.resolve(f.uri);
                this.logger.info("Processing " + String.valueOf(file));
                try {
                    this.job.getStore().transform(file, this.getProcessingPipe((Job.FileInfo)f));
                }
                catch (DITAOTException e) {
                    this.logger.error("Failed to process XML filter: " + e.getMessage(), e);
                }
            });
        } else {
            for (Job.FileInfo f2 : fis) {
                URI file = this.job.tempDirURI.resolve(f2.uri);
                this.logger.info("Processing " + String.valueOf(file));
                try {
                    this.job.getStore().transform(file, this.getProcessingPipe(f2));
                }
                catch (DITAOTException e) {
                    this.logger.error("Failed to process XML filter: " + e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private List<XMLFilter> getProcessingPipe(Job.FileInfo fi) {
        URI fileToParse = this.job.tempDirURI.resolve(fi.uri);
        assert (fileToParse.isAbsolute());
        return this.filters.stream().filter(p -> p.predicate.test(fi)).map(FilterPair::newInstance).peek(f -> {
            this.logger.debug("Configure filter " + f.getClass().getCanonicalName());
            f.setCurrentFile(fileToParse);
            f.setJob(this.job);
            f.setLogger(this.logger);
        }).collect(Collectors.toList());
    }

    public static class FilterPair {
        public final Class<? extends AbstractXMLFilter> filterClass;
        public final Predicate<Job.FileInfo> predicate;
        public final Map<String, String> params;

        public FilterPair(Class<? extends AbstractXMLFilter> filterClass, Predicate<Job.FileInfo> fileInfoFilter, Map<String, String> params) {
            this.filterClass = filterClass;
            this.predicate = fileInfoFilter;
            this.params = params;
        }

        public AbstractXMLFilter newInstance() {
            try {
                AbstractXMLFilter f = this.filterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.params.forEach(f::setParam);
                return f;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

