/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.functions.Round;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.ContextFreeAtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public abstract class NumericValue
extends AtomicValue
implements XPathComparable,
AtomicMatchKey,
ContextFreeAtomicValue {
    public NumericValue(AtomicType typeLabel) {
        super(typeLabel);
    }

    public static NumericValue parseNumber(String in) {
        if (in.indexOf(101) >= 0 || in.indexOf(69) >= 0) {
            try {
                return new DoubleValue(Double.parseDouble(in));
            }
            catch (NumberFormatException e) {
                return DoubleValue.NaN;
            }
        }
        if (in.indexOf(46) >= 0) {
            ConversionResult v = BigDecimalValue.makeDecimalValue(in, true);
            if (v instanceof ValidationFailure) {
                return DoubleValue.NaN;
            }
            return (NumericValue)v;
        }
        ConversionResult v = Int64Value.stringToInteger(in);
        if (v instanceof ValidationFailure) {
            return DoubleValue.NaN;
        }
        return (NumericValue)v;
    }

    public abstract double getDoubleValue();

    public abstract float getFloatValue();

    public abstract BigDecimal getDecimalValue() throws ValidationException;

    @Override
    public abstract boolean effectiveBooleanValue();

    public static boolean isInteger(AtomicValue value) {
        return value instanceof IntegerValue;
    }

    public abstract long longValue() throws XPathException;

    public abstract NumericValue negate();

    public abstract NumericValue floor();

    public abstract NumericValue ceiling();

    public abstract NumericValue round(int var1);

    public abstract NumericValue round(int var1, Round.RoundingRule var2);

    public abstract int signum();

    public boolean isNegativeZero() {
        return false;
    }

    public abstract boolean isWholeNumber();

    public abstract int asSubscript();

    public abstract NumericValue abs();

    @Override
    public final AtomicMatchKey getXPathMatchKey(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) throws NoDynamicContextException {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable() {
        return this;
    }

    @Override
    public int compareTo(XPathComparable other) {
        if (other instanceof NumericValue) {
            double b;
            double a = this.getDoubleValue();
            if (a == (b = ((NumericValue)other).getDoubleValue())) {
                return 0;
            }
            if (a < b) {
                return -1;
            }
            return 1;
        }
        throw new ClassCastException("Cannot compare numeric value to " + other.toString());
    }

    @Override
    public abstract int compareTo(long var1);

    @Override
    public final boolean equals(Object other) {
        return other instanceof NumericValue && this.compareTo((NumericValue)other) == 0;
    }

    @Override
    public abstract int hashCode();

    @Override
    public String show() {
        return this.getStringValue();
    }
}

