/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.JarWithModuleAttributes;
import org.netbeans.nbbuild.UpdateTracking;

public class MakeListOfNBM
extends Task {
    File outputFile = null;
    String moduleName = null;
    boolean pok = true;
    FileSet fs = null;
    private ArrayList<String> locales = new ArrayList();
    private ArrayList<String> brandings;

    public MakeListOfNBM() {
        this.locales.add("");
        this.brandings = new ArrayList();
        this.brandings.add("");
    }

    public void setOutputfiledir(File s) {
        this.outputFile = s;
        this.log("Setting outputfile to " + s, 4);
    }

    public FileSet createFileSet() {
        this.fs = new FileSet();
        return this.fs;
    }

    public void setModule(String s) {
        this.moduleName = s;
        this.log("Setting moduleName to " + s, 4);
    }

    public void setTargetName(String t) {
        this.pok = false;
        this.log("<" + this.getTaskName() + "> attribute targetname has been DEPRECATED");
    }

    public void setLocales(String s) {
        for (String st : s.split("[, ]+")) {
            this.locales.add(st);
        }
    }

    public List<String> getLocales() {
        return this.locales;
    }

    public void setBrandings(String s) {
        if (s.startsWith("${")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ", ");
        while (st.hasMoreTokens()) {
            this.brandings.add(st.nextToken());
        }
    }

    public List<String> getBrandings() {
        return this.brandings;
    }

    public void execute() throws BuildException {
        Attributes attr;
        if (!this.pok) {
            throw new BuildException("Use the fileset to specify the content of the NBM");
        }
        if (this.outputFile == null) {
            throw new BuildException("You have to specify output directoty");
        }
        if (this.moduleName == null) {
            throw new BuildException("You have to specify the main module's file");
        }
        if (this.fs == null) {
            throw new BuildException("You have to specify the fileset of files included in this module");
        }
        UpdateTracking track = new UpdateTracking(this.outputFile.getAbsolutePath());
        JarFile jar = null;
        File module = new File(this.outputFile, this.moduleName);
        try {
            jar = new JarFile(module);
            attr = jar.getManifest().getMainAttributes();
        }
        catch (IOException ex) {
            throw new BuildException("Can't get manifest attributes for module jar file " + module.getAbsolutePath(), (Throwable)ex, this.getLocation());
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException ex1) {
                String exmsg = ex1.getMessage();
                if (exmsg == null) {
                    exmsg = "Unknown error";
                }
                this.log("Caught I/O Exception (msg:\"" + exmsg + "\") when trying to close jar file " + module.getAbsolutePath(), 1);
            }
        }
        boolean[] osgi = new boolean[1];
        String codename = JarWithModuleAttributes.extractCodeName(attr, osgi);
        if (codename == null) {
            throw new BuildException("Manifest in jar file " + module.getAbsolutePath() + " does not contain OpenIDE-Module", this.getLocation());
        }
        String cnb = codename.replaceFirst("/\\d+$", "");
        this.log("Generating Auto Update information for " + cnb);
        String versionTag = osgi[0] ? "Bundle-Version" : "OpenIDE-Module-Specification-Version";
        String versionSpecNum = attr.getValue(versionTag);
        if (versionSpecNum == null) {
            this.log("Manifest in jar file " + module.getAbsolutePath() + " does not contain tag " + versionTag);
            versionSpecNum = "0";
        }
        UpdateTracking.Version version = track.addNewModuleVersion(codename, versionSpecNum);
        this.fs.createInclude().setName("config" + File.separator + "Modules" + File.separator + track.getTrackingFileName());
        this.updateFileSetForLorB(this.fs);
        DirectoryScanner ds = this.fs.getDirectoryScanner(this.getProject());
        ds.scan();
        String lmnl = this.getProject().getProperty("locmakenbm.locales");
        String lmnb = this.getProject().getProperty("locmakenbm.brands");
        if (lmnl != null && !lmnl.trim().equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(lmnl, ", ");
            int cntTok = tokenizer.countTokens();
            String[] lmnLocales = new String[cntTok];
            for (int j = 0; j < cntTok; ++j) {
                String s;
                lmnLocales[j] = s = tokenizer.nextToken();
                this.log("  lmnLocales[j] == " + lmnLocales[j], 4);
            }
            String[] lmnBrands = null;
            if (lmnb != null && !lmnb.trim().equals("")) {
                tokenizer = new StringTokenizer(lmnb, ", ");
                cntTok = tokenizer.countTokens();
                lmnBrands = new String[cntTok];
                for (int j = 0; j < cntTok; ++j) {
                    String s;
                    lmnBrands[j] = s = tokenizer.nextToken();
                    this.log("  lmnBrands[j] == " + lmnBrands[j], 4);
                }
            }
            String[] englishFiles = ds.getIncludedFiles();
            Object moduleJar = null;
            boolean skipLocaleDir = false;
            for (int k = 0; k < englishFiles.length; ++k) {
                String fext;
                String fname;
                String filename;
                String dirName;
                skipLocaleDir = englishFiles[k].lastIndexOf("/locale/") >= 0 || englishFiles[k].lastIndexOf(File.separator + "locale" + File.separator) >= 0;
                this.log("Examining file " + englishFiles[k], 4);
                int sepPos = englishFiles[k].lastIndexOf(File.separator);
                if (sepPos < 0) {
                    dirName = "";
                    filename = englishFiles[k];
                } else {
                    dirName = englishFiles[k].substring(0, sepPos);
                    filename = englishFiles[k].substring(sepPos + File.separator.length());
                }
                int extPos = filename.lastIndexOf(46);
                if (extPos < 0) {
                    fname = filename;
                    fext = "";
                } else {
                    fname = filename.substring(0, extPos);
                    fext = filename.substring(extPos);
                }
                for (int j = 0; j < lmnLocales.length; ++j) {
                    String newinc = skipLocaleDir ? dirName + File.separator + fname + "_" + lmnLocales[j] + "*" + fext : dirName + File.separator + "locale" + File.separator + fname + "_" + lmnLocales[j] + "*" + fext;
                    this.log("  adding include mask \"" + newinc + "\"", 4);
                    this.fs.setIncludes(newinc);
                    if (lmnBrands == null) continue;
                    for (int i = 0; i < lmnBrands.length; ++i) {
                        newinc = skipLocaleDir ? dirName + File.separator + fname + "_" + lmnBrands[i] + "_" + lmnLocales[j] + "*" + fext : dirName + File.separator + "locale" + File.separator + fname + "_" + lmnBrands[i] + "_" + lmnLocales[j] + "*" + fext;
                        this.log("  adding include mask \"" + newinc + "\"", 4);
                        this.fs.setIncludes(newinc);
                    }
                }
            }
            ds = this.fs.getDirectoryScanner(this.getProject());
            ds.scan();
        }
        Object[] include = ds.getIncludedFiles();
        this.log("Including files " + Arrays.toString(include), 3);
        for (int j = 0; j < include.length; ++j) {
            String path = ((String)include[j]).replace(File.separatorChar, '/');
            if (osgi[0] && !path.equals(this.moduleName) && !path.equals("config/Modules/" + cnb.replace('.', '-') + ".xml")) {
                throw new BuildException("Cannot include other files with an OSGi bundle: " + path, this.getLocation());
            }
            try {
                File inFile = new File(ds.getBasedir(), (String)include[j]);
                CRC32 crc = UpdateTracking.crcForFile(inFile);
                String abs = inFile.getAbsolutePath();
                String prefix = ds.getBasedir().getAbsolutePath() + File.separatorChar;
                if (!abs.startsWith(prefix)) {
                    throw new IllegalStateException(abs);
                }
                version.addFileWithCrc(abs.substring(prefix.length()).replace(File.separatorChar, '/'), Long.toString(crc.getValue()));
                continue;
            }
            catch (IOException ex) {
                this.log(ex.toString());
            }
        }
        track.write();
    }

    private void updateFileSetForLorB(FileSet fs) {
        if (this.locales.size() == 1 && this.brandings.size() == 1) {
            return;
        }
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] included = ds.getIncludedFiles();
        ArrayList<String> newIncludes = new ArrayList<String>();
        for (String include : included) {
            String fext;
            String fname;
            String filename;
            String dirName;
            int sepPos = (include = include.replace(File.separatorChar, '/')).lastIndexOf(47);
            if (sepPos < 0) {
                dirName = "";
                filename = include;
            } else {
                dirName = include.substring(0, sepPos);
                filename = include.substring(sepPos + 1);
            }
            int extPos = filename.lastIndexOf(46);
            if (extPos < 0) {
                fname = filename;
                fext = "";
            } else {
                fname = filename.substring(0, extPos);
                fext = filename.substring(extPos);
            }
            for (String branding : this.brandings) {
                for (String loc : this.locales) {
                    String newinc = dirName + "/locale/" + fname;
                    if (branding.length() > 0) {
                        newinc = newinc + "_" + branding;
                    }
                    if (loc.length() > 0) {
                        newinc = newinc + "_" + loc;
                    }
                    if ((newinc = newinc + fext).startsWith("/")) {
                        newinc = newinc.substring(1);
                    }
                    newIncludes.add(newinc);
                    this.log("Added include mask: " + newinc, 3);
                    if (dirName.length() != 0) continue;
                    newinc = fname;
                    if (branding.length() > 0) {
                        newinc = newinc + "_" + branding;
                    }
                    if (loc.length() > 0) {
                        newinc = newinc + "_" + loc;
                    }
                    newinc = newinc + fext;
                    newIncludes.add(newinc);
                    this.log("Added cluster-root include mask: " + newinc, 3);
                }
            }
        }
        for (String inc : newIncludes) {
            fs.setIncludes(inc);
        }
    }
}

